--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A TextField allows you to enter a single line of text and submit with a button. You can also force it to only accept numbers with the `numbersOnly` field.
--- @class mwseMCMTextField : mwseMCMSetting, mwseMCMComponent
--- @field buttonText string The text shown on the button next to the input field. The default text is a localized version of: "Submit".
--- @field elements mwseMCMParagraphFieldElements|mwseMCMTextFieldElements This dictionary-style table holds all the UI elements of the TextField, for easy access.
--- @field label string Text shown above the text field.
--- @field minHeight integer|nil The minimum height set on the `self.elements.border` UI element.
--- @field numbersOnly boolean If true, only numbers will be allowed in this TextField.
--- @field sNewValue string The message shown after a new value is submitted. This can be formatted with a '%s' which will be replaced with the new value. The default text is a localized version of: "New value: '%s'".
mwseMCMTextField = {}

--- This method is called when setting is updated. Shows a messageBox with `self.sNewValue` with curent variable value formatted in.
function mwseMCMTextField:callback() end

--- This method creates the UI elements specific to TextField.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTextField:createContentsContainer(parentBlock) end

--- This method creates the submit button UI element and stores it in `self.elements.submitButton`.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTextField:createSubmitButton(parentBlock) end

--- This method creates the border and inputField UI elements of the TextField.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTextField:makeComponent(parentBlock) end

--- Creates a new TextField.
--- @param data? mwseMCMTextField.new.data This table accepts the following values:
--- 
--- `label?`: string — *Optional*. Text shown above the text field.
--- 
--- `buttonText?`: string — *Optional*. The text shown on the button next to the input field. The default text is a localized version of: "Submit".
--- 
--- `variable?`: mwseMCMConfigVariable|mwseMCMCustomVariable|mwseMCMGlobal|mwseMCMGlobalBoolean|mwseMCMPlayerData|mwseMCMTableVariable|mwseMCMVariable|mwseMCMSettingNewVariable — *Optional*. A variable for this setting.
--- 
--- `numbersOnly?`: boolean — *Default*: `false`. If true, only numbers will be allowed in this TextField.
--- 
--- `description?`: string — *Optional*. If in a [Sidebar Page](../types/mwseMCMSideBarPage.md), the description will be shown on mouseover.
--- 
--- `press?`: fun(self: mwseMCMTextField) — *Optional*. This allows overriding the default implementation of this method. Can be overriden to add a confirmation message before updating. This function should call `self:update()` at the end.
--- 
--- `sNewValue?`: string — *Optional*. The message shown after a new value is submitted. This can be formatted with a '%s' which will be replaced with the new value. The default text is a localized version of: "New value: '%s'".
--- 
--- `minHeight?`: integer — *Optional*. The minimum height set on the `self.element.border` UI element.
--- 
--- `callback?`: fun(self: mwseMCMTextField) — *Optional*. This allows overriding the default implementation of this method. See its [description](../types/mwseMCMTextField.md#callback).
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. If true, the setting is disabled while the game is on main menu.
--- 
--- `restartRequired?`: boolean — *Default*: `false`. If true, updating this Setting will notify the player to restart the game.
--- 
--- `restartRequiredMessage?`: string — *Optional*. The message shown if restartRequired is triggered. The default text is a localized version of: "The game must be restarted before this change will come into effect."
--- 
--- `indent?`: integer — *Default*: `12`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `postCreate?`: fun(self: mwseMCMTextField) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- 
--- `class?`: string — *Optional*. No description yet available.
--- 
--- `componentType?`: string — *Optional*. No description yet available.
--- 
--- `parentComponent?`: mwseMCMActiveInfo|mwseMCMBinder|mwseMCMButton|mwseMCMCategory|mwseMCMColorPicker|mwseMCMColorPickerButton|mwseMCMComponent|mwseMCMCycleButton|mwseMCMDropdown|mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMHyperlink|mwseMCMInfo|mwseMCMKeyBinder|mwseMCMLogLevelOptions|mwseMCMMouseBinder|mwseMCMMouseOverInfo|mwseMCMMouseOverPage|mwseMCMOnOffButton|mwseMCMPage|mwseMCMParagraphField|mwseMCMPercentageSlider|mwseMCMSetting|mwseMCMSideBarPage|mwseMCMSideBySideBlock|mwseMCMSlider|mwseMCMTemplate|mwseMCMTextField|mwseMCMYesNoButton — *Optional*. No description yet available.
--- @return mwseMCMParagraphField|mwseMCMTextField textField No description yet available.
function mwseMCMTextField:new(data) end

---Table parameter definitions for `mwseMCMTextField.new`.
--- @class mwseMCMTextField.new.data
--- @field label? string *Optional*. Text shown above the text field.
--- @field buttonText? string *Optional*. The text shown on the button next to the input field. The default text is a localized version of: "Submit".
--- @field variable? mwseMCMConfigVariable|mwseMCMCustomVariable|mwseMCMGlobal|mwseMCMGlobalBoolean|mwseMCMPlayerData|mwseMCMTableVariable|mwseMCMVariable|mwseMCMSettingNewVariable *Optional*. A variable for this setting.
--- @field numbersOnly? boolean *Default*: `false`. If true, only numbers will be allowed in this TextField.
--- @field description? string *Optional*. If in a [Sidebar Page](../types/mwseMCMSideBarPage.md), the description will be shown on mouseover.
--- @field press? fun(self: mwseMCMTextField) *Optional*. This allows overriding the default implementation of this method. Can be overriden to add a confirmation message before updating. This function should call `self:update()` at the end.
--- @field sNewValue? string *Optional*. The message shown after a new value is submitted. This can be formatted with a '%s' which will be replaced with the new value. The default text is a localized version of: "New value: '%s'".
--- @field minHeight? integer *Optional*. The minimum height set on the `self.element.border` UI element.
--- @field callback? fun(self: mwseMCMTextField) *Optional*. This allows overriding the default implementation of this method. See its [description](../types/mwseMCMTextField.md#callback).
--- @field inGameOnly? boolean *Default*: `false`. If true, the setting is disabled while the game is on main menu.
--- @field restartRequired? boolean *Default*: `false`. If true, updating this Setting will notify the player to restart the game.
--- @field restartRequiredMessage? string *Optional*. The message shown if restartRequired is triggered. The default text is a localized version of: "The game must be restarted before this change will come into effect."
--- @field indent? integer *Default*: `12`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field postCreate? fun(self: mwseMCMTextField) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @field class? string *Optional*. No description yet available.
--- @field componentType? string *Optional*. No description yet available.
--- @field parentComponent? mwseMCMActiveInfo|mwseMCMBinder|mwseMCMButton|mwseMCMCategory|mwseMCMColorPicker|mwseMCMColorPickerButton|mwseMCMComponent|mwseMCMCycleButton|mwseMCMDropdown|mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMHyperlink|mwseMCMInfo|mwseMCMKeyBinder|mwseMCMLogLevelOptions|mwseMCMMouseBinder|mwseMCMMouseOverInfo|mwseMCMMouseOverPage|mwseMCMOnOffButton|mwseMCMPage|mwseMCMParagraphField|mwseMCMPercentageSlider|mwseMCMSetting|mwseMCMSideBarPage|mwseMCMSideBySideBlock|mwseMCMSlider|mwseMCMTemplate|mwseMCMTextField|mwseMCMYesNoButton *Optional*. No description yet available.

--- Calls the `update` method.
function mwseMCMTextField:press() end

--- Changes the TextField's `variable.value` to the given value, updates the TextField's label and widget, and calls `self:update`.
--- @param newValue string No description yet available.
function mwseMCMTextField:setVariableValue(newValue) end

--- Updates the variable's value to the current text in the text input element. If `self.numbersOnly` is true, it only allows setting the new value to a number.
function mwseMCMTextField:update() end

